/*====================================================================*/
/* Diese Datei enthlt die Definition der Systemvariablen und Macros  */
/* fr EdiTasc. Sie wird von EdiTasc und anderen Programmen beim      */
/* Programmstart ausgefhrt und nicht verndert.                      */
/* Die Werte der Variablen und der Macro-Code kann von anderen Teilen */
/* von EdiTasc und anderen Macros verndert/berschrieben werden.     */
/*                                                                    */
/* This file contains the definition of system variables and for      */
/* EdiTasc. It is executed by EditTasc and other programs on startup  */
/* and will not be changed.                                           */
/* The Values of the variables and the macro code may be changed by   */
/* EdiTasc and by other macros or system files.                       */
/*====================================================================*/
/* General parameters                                                 */
/*--------------------------------------------------------------------*/
_EditorLang0 = "scall";
_EditorLang1 = "DinSCall";
_EditorLang2 = "IselSCall";

M_PI = PI = 2.0 * acos 0.0; _d2r = M_PI / 180.0;

_lang = "x";                     /* make language available as STRING */
_lang[0] = _Language;
_IDEflag = 0;                    /* set to 1 when VB runs in IDE mode */ 

ConfigEdit "WRITE";              /* der zu verwendende externe Editor */

_test = 1;                       /* initialize in test mode           */
_demo = 0;

_mode = '0';                     /* execution mode: 
                                         'X': machine, 
                                         'G': graphic, 
                                         '0': other, e.g. editor      */

if(T_undefined == (TypeOf "_ThrFlags").type) {_ThrFlags = 2L;}

/*--------------------------------------------------------------------*/
/* Variables and Macros for reading data from ini files               */
/*--------------------------------------------------------------------*/
IniFileMt  = _path & "/Mtasc.ini";
IniFileTxt = _path & "/MtMacroTxt.ini";
IniFileDrv = _path & "/Mtdrv.ini";

(MacroDef "GetIniStr") = "GetIniString IniFileMt \"Mtasc\" %1 \"\";";
(MacroDef "GetIniPrm") = "GetIniString IniFileMt %1 %2 \"\";";
(MacroDef "GetIniDrv") = "GetIniString IniFileDrv \"Driver\" %1 \"0\";";
(MacroDef "GetIniTxt") = "GetIniString IniFileTxt %1 (%2 & _lang) 
                          (%2 & \": Error with missing text\");";
(MacroDef "_ErrHandler") =
"MsgBox _sysMsg.errText \"" & (GetIniTxt "System" "ErrBoxCapt") & "\" MB_OK;";

(MacroDef "GetIniDbl") =
"Local \"Txt\" \"Erg\" \"Ind\";
Txt = GetIniString IniFileMt \"Mtasc\" %1 \"0.0\";
Ind = 0L; if(%P == 2) {Ind = %2;}
0.0 + GetStkObj Ind scall Txt & \" 0 0 0 0 0 0 0 0 \";";

(MacroDef "GetIniInt") =
"Local \"Txt\" \"Erg\" \"Ind\";
Txt = GetIniString IniFileMt \"Mtasc\" %1 \"0\";
Ind = 0L; if(%P == 2) {Ind = %2;}
0L + GetStkObj Ind scall Txt & \" 0 0 0 0 0 0 0 0 \";";

/*--------------------------------------------------------------------*/
/* Format sTrings                                                     */
/*--------------------------------------------------------------------*/
(MacroDef "_fmtCoord") = "sprint \"%.3lf\"   %1 + 0.0";
(MacroDef "_fmtSpeed") = "sprint \"%.1lf\"   %1 + 0.0";
(MacroDef "_fmtFac")   = "sprint \"%.4lf\"   %1 + 0.0";
(MacroDef "_fmtI16")   = "sprint \"%d\"      %1 + 0L";
(MacroDef "_fmtI32")   = "sprint \"%dL\"     %1 + 0L";
(MacroDef "_fmtHex")   = "sprint \"0x%.8XL\" %1 + 0L";

_fdspCoord = "%9.3lf";
_fdspInt   = "%9.0lf";

/* ------------------------------------------------------------------ */
/* GCode settings                                                     */ 
/* ------------------------------------------------------------------ */
if(FileExists _Path & "/GFuncTable.ts"){fcall _Path & "/GFuncTable.ts";}

CGCodeParInit.IJKMode   = '0';     /* GCode default settings          */
CGCodeParInit.FFac      =  1.0;
CGCodeParInit.IJKTol    =  0.01;
CGCodeParInit.HelixMode =  0; 

if(FileExists IniFileMt)           /* Replace with mTasc values       */
 {CGCodeParInit.IJKMode   = (GetIniStr "CGCodeParInit.IJKMode")[0];
  CGCodeParInit.FFac      =  GetIniDbl "CGCodeParInit.FFac";
  CGCodeParInit.IJKTol    =  GetIniDbl "CGCodeParInit.IJKTol";
  CGCodeParInit.HelixMode =  GetIniInt "CGCodeParInit.HelixMode";
 }

/*--------------------------------------------------------------------*/
/* Initialize Dgi and driver object                                   */
/*--------------------------------------------------------------------*/
AxisLetters "XYZABCUV";            /* Sequence of axis letters        */
if(FileExists IniFileMt) {AxisLetters GetIniStr "AxisLett";} 

NewObjListThr;                     /* thread local variable list      */
NewDgi;                            /* create DGI object               */ 

local "DrvMode" "G3Mode" "ExcMode";
DrvMode = _ThrFlags and 3;         /* Type of driver object           */ 
G3Mode  = _ThrFlags and 12;        /* Type of g3Graph usage           */ 
ExcMode = _ThrFlags and 48;        /* Type of ExecMacros usage        */

G3Mode  = G3Mode / 4;  
ExcMode = ExcMode / 16;  

if(DrvMode == 1) {NewDgiDrv 0;}    /* create Driver object "slave"    */
if(DrvMode == 2)
{
  NewDgiDrv 1;                     /* create Driver object "master"   */
  _dgiOutCtrl.drv = 1;             /* enable output via Driver object */
}

ThreadFlags "AllowPeekMessage" 1;  /* Msg. handling (user interface)  */
_SpinLimit      = 5;               /* reentrance level                */

/*--------------------------------------------------------------------*/
/* Compatibility                                                      */
/*--------------------------------------------------------------------*/
if(0 > checkver 'M' 6 54 8 4)      /* check version of MTasc.dll      */ 
 {Mreset sprint (GetIniTxt "System" "ErrVersion") "6.54.8.4";}                                   

/*--------------------------------------------------------------------*/
/* some EdiTasc variables and macros                                  */
/*--------------------------------------------------------------------*/
_KeyCode      = 0;
_AllowManStep = 0;

Mlimit '0';
MlimitIsSuspended = 0; /* suspended limit watching during tool change */

_MirrX    = "0.0";                         /* X-value of mirror axis  */

_autoDraw  =  0;        /* show graphic automatically after file open */
_autoClear =  1;        /* clear screen before showing new graphic    */

_ColorIndex  = 1;                          /* Index for color scheme  */
HpglUnitFlag = 0;                          /* default HPGL unit       */

(MacroDef "mfHide") =                      /* invisible mf commands   */
"if(_mode == 'G'){_grMode = 0;}
 mf;
 if(_mode == 'G'){_grMode = 1;}
";

(MacroDef "_dspUpdate") = "";              /* replaced by callback    */

(MacroDef "TeachXGetCmd") = "\"mf;\";";    /* Teach extension:        */
                                           /* returns insert-string   */

TeachXLabel = GetIniString (_Path & "/EditascTxt.ini") "PrgHelp" ("064" & _lang);

/*--------------------------------------------------------------------*/
/* motion actor, handles all motion commands and parameters           */
/* Todo: Treiber oder Grafik muss da sein...                          */
/*--------------------------------------------------------------------*/
mact = ObjDef CMActor;
mact.dgiAttach;

(MacroDef "MoListOpen") =
"
 DeleteDgiMObjList;
 if(1 != (typeof %1).type)
 {
  erase scall %1;
 }
 scall %1 & \" = &(ObjDef CMObjList);\";
 NewDgiMObjList scall %1;
 (*(scall %1)).<0>.dim= 2;
 _dgiOutCtrl.drv = 0;
 _dgiOutCtrl.mObjList = 2;
";

(MacroDef "MoListClose") =
"
 _dgiOutCtrl.drv = 1;
 _dgiOutCtrl.mObjList = 0;
 mreset;
";

/*====================================================================*/
/* Load default values for speed and acceleration                     */
/*====================================================================*/
MF_F  = 20.0;                           /* default settings for speed */
ML_F  = 10.0;
MLD_F =  5.0;

MF_R  = 500.0;                          /* default acceleration values*/
ML_R  = 500.0;
MLD_R = 500.0;
                                        /* values for positioning     */  
MP_F = ARRAY _drvnMax  20.0  20.0  20.0  20.0  20.0  20.0  20.0  20.0;
MP_R = ARRAY _drvnMax 200.0 200.0 200.0 200.0 200.0 200.0 200.0 200.0;

if(FileExists IniFileMt)                /* Replace with mTasc values  */
 {MF_F  = GetIniDbl "SpeedFast";
  ML_F  = GetIniDbl "SpeedSlow";
  MLD_F = GetIniDbl "SpeedDown";    if(MLD_F == 0.0){MLD_F = ML_F;}

  MF_R  = GetIniDbl "AccelFast";
  ML_R  = GetIniDbl "AccelSlow";
  MLD_R = GetIniDbl "AccelDown";    if(MLD_R == 0.0){MLD_R = ML_R;}

  MP_F = ARRAY _drvnMax Scall GetIniStr "SpeedPosi";
  MP_R = ARRAY _drvnMax Scall GetIniStr "AccelPosi";
 }

MvPar;                                  /* Apply all settings         */

/*====================================================================*/
/* Offset and pickpos table                                           */
/*====================================================================*/
CMc2Oc = ObjDef T_classDscr             /* Offset class               */
"Text"  T_object 0                      /* offset description         */
"Flags" T_short  0                      /* Nullpunkts-Verwendung      */
"iMt"   T_short  0                      /* index for extended transf. */
"ofs"   T_double _drvnMax;              /* one offset for each axis   */

PickPos = ObjDef CMc2Oc 1;              /* Default: Nur Taster        */

_nPosOfs = 4;                           /* load initial positions     */
Mc2Oc = ObjDef CMc2Oc _nPosOfs;         /* Maschinen-Positionen       */
i = 0L; for _nPosOfs
{
 Mc2Oc[i].ofs   = ARRAY _drvnMax 0.0;
 Mc2Oc[i].iMt   = 0;
 Mc2Oc[i].Flags = 0;
 i = i + 1;
}

(*Mc2Oc[0].Text) = "Maschinen-Nullpunkt (fest)";
(*Mc2Oc[1].Text) = "Temporrer Nullpunkt";
(*Mc2Oc[2].Text) = "Parkposition";
(*Mc2Oc[3].Text) = "Werkzeugwechsel-Position";

_indMc2Oc = 0;                          /* Default offset index       */

(MacroDef "SetMc2Oc") =                 /* select workpiece origin    */ 
"if(ThreadFlags \"DrvLoaded\")
 {wait 0; MpLock '+';
  local \"CallOnExit\"; CallOnExit = \"MpLock '-';\";
  _IndMc2Oc = %1;

  mcall (*_MtList[Mc2Oc[%1].iMt]) Mc2Oc[%1].ofs Tools[_ToolNc].ofs;
  _mtStat.dirtyTrans = 1;
  WriteIniString (_Path & \"/EdiTasc.ini\") \"ToolConfig\" \"CurrIndOrig\"
                 (sprint \"%d\" _IndMc2Oc + 0L); 
 }

 if(0 == ThreadFlags \"DrvLoaded\") {_IndMc2Oc = %1;}
";

/*====================================================================*/
/* Driver dependent settings and macros                               */
/*====================================================================*/
if(ThreadFlags "DrvLoaded")
{
/*--------------------------------------------------------------------*/
/* Support searching of Reference Point (file must exist)             */
/*--------------------------------------------------------------------*/
   fcall _Path & "/Macros/RefMacros.ts";

/*--------------------------------------------------------------------*/
/* Input and output definitinos, settings and macros (_iget, _oset..) */
/*--------------------------------------------------------------------*/
   if(FileExists _Path & "/Macros/IoSettings.ts")
    {fcall _Path & "/Macros/IoSettings.ts";}     

/*--------------------------------------------------------------------*/
/* Jogwheel and Joystick settings and macros                          */
/*--------------------------------------------------------------------*/
   if(FileExists _Path & "/Macros/JogSettings.ts")
    {fcall _Path & "/Macros/JogSettings.ts";}  
}

/*====================================================================*/
/* "Master" dependent settings and macros                             */
/*====================================================================*/
if(FileExists _Path & "/Macros/ToolMacros.ts")         
 {fcall _Path & "/Macros/ToolMacros.ts";} /* "GetTool", "LoadTools"...*/

/*====================================================================*/
/* Execution parameters and macros (required if "Master" + "Exec")    */
/*====================================================================*/
/* Uses:    DgiDrv                                                    */ 
/* Used by: EdiTasc                                                   */
/*--------------------------------------------------------------------*/
/* ExecMacros: _PrgDraw, _CallPrgDrawThread                           */ 
/*             _PrgExec, _PrgDrawExecRepeat                           */ 
/*                                                                    */ 
/* Start/Stop: _PrgOn,    _PrgOff,  _PrgAbort, _PrgCont               */ 
/*             _PrgStart, _PrgStop, _PrgEnd                           */
/*                                                                    */ 
/* Selecting:  _vciGotoStart,  _vciLeaveEnd                           */
/*             _vciGotoStartG, _vciLeaveEndG                          */ 
/*                                                                    */ 
/* Other:      _MouseMoveXY, _SetOcNull, _SetOcCurr                   */
/*                                                                    */ 
/* TransParm:  _MTransOn, _MTransOff                                  */ 
/*                                                                    */ 
/* FileParm:   Data structures for file and project management        */ 
/*                                                                    */ 
/* Bikub:      Macros for z level compensation                        */ 
/*--------------------------------------------------------------------*/
if((DrvMode == 2) AND (ExcMode > 0))      /* "Master" + "Exec"        */
{
  fcall _Path & "/Macros/ExecMacros.ts";  /* execution macros         */
  fcall _Path & "/Macros/TransParm.ts";   /* transformation macros    */
  fcall _Path & "/Macros/FileParm.ts";    /* file and project data    */

  if((options "bikub") and (FileExists _Path & "/ZLevel/BiKubMacros.ts"))
   {fcall _Path & "/ZLevel/BiKubMacros.ts";}

/*--------------------------------------------------------------------*/
/* Info table                                                         */
/*--------------------------------------------------------------------*/
  CInfoTab = ObjDef T_classDscr         /* Info class                 */
  "Text" T_object 8                     /* Texte                      */
  "Tdty" T_Short  0                     /* Text wurde gendert        */
  "Data" T_object 8                     /* Daten                      */
  "Ddty" T_Short  0;                    /* Daten wurden gendert      */

  InfoTab = ObjDef CInfoTab 0;          /* Info-Objekt anlegen        */
}
  
/*====================================================================*/
/* Parameters and macros for cutter radius compensation               */ 
/*====================================================================*/
_crcBufSize = 2;                         /* nach soviel Stzen wird   */
                                         /* "tool down" erzeugt       */
_crcNOpen   = _crcBufSize - 1;
_crcPlane   = 2;                         /* XY-Ebene fr CRC          */

_mtStat.crcState  = 0;                   /* Radiuskorrektur-STatus    */

(MacroDef "MCrcSet") =                   /* Radiuskorrektur ein/aus   */
"_crcOri    = %1;
 _crcClosed = %2;
 if(%1 != 0){_mtStat.crcState = 1;}
 if(%1 == 0){_mtStat.crcState = 0; crcClose;}
";

/*====================================================================*/
/* load Dxf-macros (optional)                                         */
/*====================================================================*/
if(FileExists _Path & "/Macros/DxfInit.ts")
 {fcall _Path & "/Macros/DxfInit.ts";}    /* Processing of DXF output */

/*====================================================================*/
/* load Gerber-macros (optional)                                      */
/*====================================================================*/
if(FileExists _Path & "/Macros/GrbInit.ts")
 {fcall _Path & "/Macros/GrbInit.ts";} /* Processing of Gerber output */

/*====================================================================*/
/* Macro definitions for circle, rectangle, spline, helix (optional)  */
/*====================================================================*/
if(FileExists _Path & "/Macros/ShapeMacros.ts")
 {fcall _Path & "/Macros/ShapeMacros.ts";}/* "Circle", "rectangle"... */

/*====================================================================*/
/* Matrix and vector macros (required)                                */
/*====================================================================*/
fcall _Path & "/Macros/VectorMacros.ts";  /* "_mti33", "GetM33R"...   */

/*--------------------------------------------------------------------*/
/* miscellaneous                                                      */
/*--------------------------------------------------------------------*/
(MacroDef "_SetOvr")     = "SetOvr _Ovr = %1;"; _Ovr = 100;

(MacroDef "OvrChg2Neg")  = (MacroDef "OvrChg2Pos") = "";
    
(MacroDef "_cmdSps")     = (MacroDef "_cmdSps2")   = "";

(MacroDef "_doorOpen")   = "0;";

(MacroDef "CustomMacro") = "MsgBox \"CustomMacro ist nicht definiert\";";

(MacroDef "_g3Push") = 
"_p0 = _ocNext;
 SetDrawPar 'L' %1 -1 -1 -1;
 _g3mmStat = _octMinMax_stat; _octMinMax_stat = 0;";

(MacroDef "_g3Pop") = 
"_ocNext = _p0;
 SetDrawPar 'L' Tools[_toolSel].Color -1 -1 -1; MvPar;
 _grMode = 0; ml; _grMode = 1; mf;
 _octMinMax_stat = _g3mmStat;";

                                          /* for SP in HPGL files     */
(MacroDef "_HpglSP") = "_HpglPen = %1; Gettool _HpglPTools[%1];";

/*--------------------------------------------------------------------*/
/* Beschriftung - obsolet, wegen Kompatibilitt beibehalten           */
/*--------------------------------------------------------------------*/
_MtColor = ARRAY 1 0xFFFFFFL;                        /* Default color */
wrOn  = "z zdn; ml;";                                /* Pen Down      */
wrOff = "z zup; mf;";                                /* Pen Up        */
wrDlyStop = 0.0;                                     /* Stop-Delay    */

/*====================================================================*/
/* Define default transformations                                     */
/*====================================================================*/
tr0 = ObjDef CMtransChain;

i = 0;                             /* ----------------- object offset */
SetAll tr0.d[i].vct 0.0;
tr0.d[i].ip = -1;
tr0.d[i].par = 1.0;

tr0.n = 1;                         /* number of instructions          */
i = 0;
tr0.cFw[i].func   = MTT_offset;    /* instruction definition          */
tr0.cFw[i].argF   = 0;
tr0.cFw[i].argIn  = MTT_use_vOut;
tr0.cFw[i].argOut = MTT_use_vOut;
tr0.cBw[i] = tr0.cFw[i];
tr0.cBw[i].func = tr0.cBw[i].func or 0x80;      /* back: inverted     */

_MtN = GetIniInt "MtExtended";          /* number of transformations  */

_MtList = ObjDef T_object _MtN + 1;     /* Array of command strings   */

if(DrvMode < 2) {_MtList[0] = &("");}

if(DrvMode == 2)
{
 _MtList[0] =                           /* standard command string    */
 &("
  tr0.d[0].vct._ = %1 - (%2 - Tools[0].ofs);
  _drvOc2Mc_0 = tr0;
  _DrvMtransSet;
 ");
}

i = 1; for(_MtN)
{                                       /* initialize transformations */
  _MtList[i] = &(*_MtList[0]);
  i = i + 1;
}

