/*====================================================================*/
/* Konvertierung von Bahnobjekt-Sequenzen nach HPGL                   */
/*====================================================================*/
/* Eingabe: Datei-Variable "fileIn"                                   */
/* Ausgabe: Datei-Variable "fileOut"                                  */
/*--------------------------------------------------------------------*/

if(0 == FileExists FileIn) {mreset "Die Eingabedatei wurde nicht gefunden:\n\n" & FileIn;}
if(FileOut == "")          {mreset "Die Ausgabedatei 'FileOut' ist nicht definiert";}

local "CallOnExit" "dst";

CallOnExit = (sprint "@Zup = %lf;" Zup)   /* variables to be restored */
           & (sprint " Zdn = %lf;" Zdn)
           & (sprint " _dgiOutCtrl.grMode = %d;" _dgiOutCtrl.grMode + 0L)
           & (sprint " _dgiOutCtrl.ncMode = %d;" _dgiOutCtrl.ncMode + 0L)
           & (sprint " _dgiOutCtrl.mtp    = %d;" _dgiOutCtrl.mtp)
           & (sprint " _dgiOutCtrl.drv    = %d;" _dgiOutCtrl.drv)
           & (sprint " _Mode              = %d;" 0 + _Mode)
           &         " DeleteDgiMtp; FileOut = \"\";"
;

zup = 10.0;                               /* initialization           */
zdn =  0.0;
dst = Array _drvNMax 0.0;

_dgiOutCtrl.mtp    = 1;
_dgiOutCtrl.drv    = 0;
_dgiOutCtrl.grMode = 0;
_dgiOutCtrl.ncMode = 3;

NewDgiMtp 'F' fileOut;

_mtp.text = &("IN; PU;\r\n");
_mtp_Add;

_mtp.linHandler = &("
 if((*_mtp.text)[0] != 'I')
 {
   dst = (*_mtp.mobj).<0>.pEnd._;
   if(dst[2] >= zup){_mtp.text = &(\"PU\");}
   if(dst[2] < zup) {_mtp.text = &(\"PD\");}
   _mtp.text = &((*_mtp.text) & sprint \"%.3lf %.3lf;\\r\\n\"
                 (dst[0] / _HpglUnitX) (dst[1] / _HpglUnitY));
 }

 if((*_mtp.text)[0] == 'I')           /* ingnore first motion command */
  {_mtp.text = &(\"\");}
");

_mtp.arcAngRes = 5.0 * _d2r;          /* Arc resulution: max. angle   */
_mtp.arcMaxLen = 5.0;                 /* Arc resolution: max. length  */

if(0){ /* if(0): Bgen in Linien Auflsen | if(1): AA generieren geht derzeit nicht */
_mtp.arcHandler = &("
 local \"ori\";
 ori = -1 + 2 * 0.0 <= 
  ((*_mtp.mobj).dirX._[0] * (*_mtp.mobj).dirY._[1]) - ((*_mtp.mobj).dirX._[1] * (*_mtp.mobj).dirY._[0]);
 _mtp.text = &(sprint \"AA%.0lf %.0lf %.2lf\\r\\n\"
  ((*_mtp.mobj).cent._[0] / _HpglUnitX) ((*_mtp.mobj).cent._[1] / _HpglUnitY)
  ((ori * (*_mtp.mobj).a1 - (*_mtp.mobj).a0) / _d2r));
");
}

z zup; mf; x _x + 1; mf;              /* begin with a small PU path   */
fcall fileIn;
wait 0;
